////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>
NS_ASSUME_NONNULL_BEGIN
@class OrchestrationUser;

/**
 * <p>The {@link NotificationRegistrationDelegate} protocol defines the specific elements required for the
 * integrator to interact during the Notification Registration flow.</p>
 *
 * <p>A {@link NotificationRegistrationDelegate} object should be provided to the {@link NotificationRegistrationParams} object
 * in order to receive feedback during the notification registration process.</p>
 * <p>This flow is initiated by the client; it is started by a call to {@link OrchestrationProtocol#startNotificationRegistration:(NotificationRegistrationParams *)}</p>
 */
NS_REFINED_FOR_SWIFT
@protocol NotificationRegistrationDelegate <NSObject>

/**
  * Called when a step of the notification registration process is complete. The provided orchestration
  * command is to be sent to the server.
  *
  * @param command an orchestration command that must be sent to the server
  */
- (void)onNotificationRegistrationStepCompleteWithCommand:(NSString *)command;

/**
 * Called upon notification registration success
 *
 * @param orchestrationUser the user for which the notification registration was successful
 * @param notificationIdentifier the notification identifier used for the registration
 */
- (void)onNotificationRegistrationSuccessWithUser:(OrchestrationUser *)orchestrationUser notificationIdentifier:(NSString *)notificationIdentifier;

@end

NS_ASSUME_NONNULL_END
